//
//  GHFetchResult.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 4/9/18.
//  Copyright © 2018 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GHWellnessData, GHHeartRateData, GHMotionIntensityData, GHBatteryData, GHStressData, GHMoveIQData, GHRestingHeartRateData, GHVO2Data, GHAccelerometerData, GHBodyBatteryData, GHSPO2Data, GHActivityData, GHBBIData, GHZeroCrossingData, GHStepData, GHRespirationData, GHFileInfoData;


#pragma mark -
/**
 *  Object containing the results from a getDataForDevice:dataTypes:fromDate:toDate:completionHandler call.
 */
@interface GHFetchResult : NSObject 

/**
 *  Wellness data for the device. Refer to GHWellnessData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHWellnessData*>* wellnessData;

/**
 *  Motion intensity data for the device. See GHMotionIntensityData for
 *  additional details about the data.
 *  @note Each data-point is grouped over similar type movement and given a score from 0 to 7.
 *        The scores are not compatible over different activities!
 */
@property (nullable, nonatomic) NSArray<GHMotionIntensityData*>* motionData;

/**
 *  Battery data for the device. Refer to GHBatteryData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHBatteryData*>* batteryData;

/**
 *  Stress data for the device. Refer to GHStressData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHStressData*>* stressData;

/**
 *  Auto-detected (MoveIQ) data. One event refers to one activity. See GHMoveIQEvent.
 *  @note The last event might be partial if it's interrupted by a sync.
 *        In this case a new one, superseeding it, will be the first in the next sync.
 */
@property (nullable, nonatomic) NSArray<GHMoveIQData*>* moveIQData;

/**
 *  Resting heart rate data for the device. Refer to GHRestingHeartRateData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHRestingHeartRateData*> *restingHeartRateData;

/**
 *  VO2 data for the device. Refer to GHVO2Data for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHVO2Data*>* vo2Data;

/**
 *  Accelerometer data for the device. Refer to GHAccelerometerData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHAccelerometerData*>* accelerometerData;

/**
 *  BodyBattery data for the device. Refer to GHBodyBatteryData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHBodyBatteryData*>* bodyBatteryData;

/**
 *  SPO2 data for the device. Refer to GHSPO2Data for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHSPO2Data*>* spo2Data;

/**
 *  Respiration data for the device. Refer to GHRespirationData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHRespirationData *>* respirationData;

/**
 *  Activity data for the device. Refer to GHActivityData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHActivityData *>* activityData;

/**
 *  BBI data for the device. Refer to GHBBIData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHBBIData *>* loggedBBIData;

/**
 *  Zero Crossing data for the device. Refer to GHZeroCrossingData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHZeroCrossingData *>* loggedZeroCrossingData;

/**
 *  Heart Rate data for the device. Refer to GHHeartRateData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHHeartRateData *>* loggedHeartRateData;

/**
 *  SPO2 data for the device. Refer to GHSPO2Data for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHSPO2Data *>* loggedSPO2Data;

/**
 *  Step data for the device. Refer to GHStepData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHStepData *>* loggedStepData;

/**
 *  Stress data for the device. Refer to GHStressData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHStressData *>* loggedStressData;

/**
 *  Respiration data for the device. Refer to GHRespirationData for
 *  additional details about the data.
 */
@property (nullable, nonatomic) NSArray<GHRespirationData *>* loggedRespirationData;

 /**
  *  Accelerometer data for the device. Refer to GHAccelerometerData for
  *  additional details about the data.
  */
@property (nullable, nonatomic) NSArray<GHAccelerometerData *>* loggedAccelerometerData;

/**
 *  The raw FIT file data from the device. Refer to GHFileInfoData for
 *  additional information.
 */
@property (nullable, nonatomic) NSArray<GHFileInfoData *> *filesData;


@end
